*******************************************************************************
*                      68000/68010 Grundprogramm ass1                         *
*                         (C) 1991 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                             Assembler Teil 1                                *
*******************************************************************************


assemble:
 move.b cotempo(a5),-(a7)       * Scrollart merken
 movea.l a7,a6                  * Merker fr Abbruch
 bsr initdebug                  * Debug initialisieren
 bsr clrscreen
 moveq #'1',d0                  * Scroll-Geschwindigkeit einstellen
 bsr esc8                       * Hardware-Scroll an, wenn mglich
 move #1,passflag(a5)           * 1. Durchgang
 move.l etxtxt(a5),d0           * Ende des Textes
 addq.l #3,d0                   * 3 addieren fr Abstand
 and.b #$fe,d0                  * Nur auf gerader Adresse
 move.l d0,macrotab(a5)         * Adresse Macrotabelle
 bsr assinit                    * Variablen initialisieren
 move.l a0,macroanf(a5)         * Adresse fr Macrotext
ass1:
 bsr geteinbuf
 bsr assline                    * Zeile assemblieren
 cmp #2,errflag(a5)
 bne.s ass1                     * Nicht Ende, dann nchste Zeile
 clr pagecnt(a5)                * Seite 0
 clr errcnt(a5)                 * Kein Fehler bisher
 addq #1,passflag(a5)           * 2. Durchgang
 bsr assinit                    * Variablen initialisieren
 lea ausbuf(a5),a0
 moveq #-1,d0                   * Alle Buchstaben fr Tag
 bsr uhrprint                   * Uhrzeit ausgeben
 bcs.s ass1a                    * Keine Uhr vorhanden
 lea ausbuf(a5),a0
 bsr prtco2                     * Zeile ausgeben
 bsr crlfe
ass1a:
 move.l a1, -(a7)
 lea kopftxt+1(pc),a1
 lea ausbuf(a5), a0
ass1b:
 move.b (a1)+, (a0)+            * berschrift nach ausbuf
 bne.s ass1b
 subq.l #1, a0                  * Null raus
 bsr prtcpu
 subq.l #1, a0                  * Null raus
 lea kopftxt1(pc), a1
ass1c:
 move.b (a1)+, (a0)+            * berschrift 2.Teil nach ausbuf
 bne.s ass1c
 subq.l #1, a0                  * Null raus
 bsr prtvers                    * Versionsnummer nach ausbuf
 subq.l #1, a0                  * Null raus
 lea kopftxt2(pc), a1
ass1d:
 move.b (a1)+, (a0)+            * berschrift 3.Teil nach ausbuf
 bne.s ass1d
 movea.l (a7)+, a1
 lea ausbuf(a5), a0
 bsr kopfaus1                   * berschrift ausgeben am Anfang
 clr.b ausbuf(a5)
 tst.b uhrausw(a5)
 beq.s ass2                     * Keine Uhr vorhanden, dann weiter
 addq.b #1,zeilen(a5)           * Uhr ist vorhanden, also eine Zeile mehr
ass2:
 move.l akttxt(a5),anfzeile(a5) * Anfangsadresse der Zeile
 tst errcnt(a5)                 * Fehler vorhanden, dann nicht verndern
 bne.s ass2a
 move.l anfzeile(a5),errzeile(a5) * Adresse der Zeile merken fr Editor
ass2a:
 bsr getquelle                  * Neue Zeile holen und letzte Zeile ausgeben
 bsr assline                    * Zeile bersetzen
 cmp.b #1,debug(a5)             * Wenn Debug aus, dann weiter
 bne.s ass2b
 move.l anfstand(a5),d0
 cmp.l pcstand(a5),d0           * Hat sich der PC-Stand verndert ?
 beq.s ass2b                    * Nein, dann weiter
 movea.l debugak(a5),a0
 move.l d0,(a0)+                * PC-Stand merken
 move.l anfzeile(a5),(a0)+      * Zeilenanfang
 clr.l (a0)                     * Endekennung
 move.l a0,debugak(a5)          * Debug-Pointer aktualisieren
ass2b:
 and.b #1,debug(a5)             * Debug jetzt aktiv, wenn DEBUGAN erfolgte
 cmp #2,errflag(a5)             * Merker fr Ende
 bne.s ass2
 bsr putausba                   * Letzte Zeile ausgeben
 bsr crlfe
 move.l pcstand(a5),d0          * PC-Adresse
 lea ausbuf(a5),a0
 bsr print6x                    * Hexadezimal
 lea ausbuf(a5),a0
 bsr prtco2                     * Ausgabe
 lea fintxt(pc),a0
 bsr put1lp                     * Text ausgeben
 move.l pcstand(a5),d0          * PC
 add.l offset(a5),d0            * + Ablageadresse
 lea ausbuf(a5),a0
 bsr print6x                    * Hexadezimal
 lea ausbuf(a5),a0
 bsr prtco2                     * Ausgabe
 lea fin1txt(pc),a0
 bsr put1lp                     * Textausgabe
 lea ausbuf(a5),a1              * Ziel
 lea fin2txt(pc),a0             * Quelle
ass3a:
 move.b (a0)+,(a1)+
 bne.s ass3a
 move errcnt(a5),d0             * Anzahl Fehler
 lea ausbuf(a5),a0
 bsr print4d                    * Dezimal ausgeben
 move.b #' ',(a0)+
 bsr putausba                   * Ausgabe
 moveq #0,d0                    * Langwort-Berechnung
 move symnext(a5),d0            * Ende der Symboltabelle
 move.l d0,d1                   * Merken
 divs #symlen,d1                * Lnge eines Eintrags
 lea symtab(a5),a0
 add.l a0,d0                    * Endadresse Symboltabelle
 lea ausbuf(a5),a0
 bsr print6x                    * Hexadezimal
 lea ausbuf(a5),a0
 bsr prtco2                     * Ausgeben
 lea fin3txt(pc),a0
 bsr prtco2                     * Text ausgeben
 lea ausbuf(a5),a0
 move d1,d0
 bsr print4d                    * Anzahl Symbole ablegen
 lea ausbuf(a5),a0
 bsr prtco2                     * Buffer ausgeben
 bsr crlfe
 tst.b debug(a5)
 beq.s ass3c                    * Wenn Debug an, dann Ende Debug-Tab. ausgeben
 lea ausbuf(a5),a0              * Ziel
 lea fin4txt(pc),a1             * Quelltext
ass3b:
 move.b (a1)+,(a0)+             * Text bertragen
 bne.s ass3b                    * Null ist Ende
 lea ausbuf(a5),a0
 move.l debugak(a5),d0          * Adresse holen
 bsr print6x                    * In ASCII wandeln
 move.b #' ',(a0)               * Null am Ende berschreiben
 bsr putausba                   * und ausgeben
ass3c:
 bsr crlfe                      * Eine Zeile Freiraum
 moveq #$c,d0
 bsr co2ausa                    * Seitenvorschub
 moveq #'0',d0
 bsr esc7                       * Jetzt auf jeden Fall wieder Software-Scroll
 move.b (a7)+,cotempo(a5)       * Fr sptere Ausgaben alte Scrollart
bra carres                      * Ende

assinit:                        * Initialisieren der Variablen fr Assembler
 clr.l rscount(a5)              * RS-Zhler auf Null
 clr.l offset(a5)               * Kein Offset bisher
 move.l pcorg(a5),pcstand(a5)   * Anfangs PC-Stand
 move.l stxtxt(a5),akttxt(a5)   * Anfang des Textes
 movea.l macrotab(a5),a0        * Macrotabelle
 clr (a0)+                      * rcksetzen
rts                             * Adresse der Tabelle zurckliefern

kopfaus:                        * berschrift ausgeben
 move.l a1, -(a7)
 lea kopftxt(pc),a1
 lea ausbuf(a5), a0
kpfaus1a:
 move.b (a1)+, (a0)+            * berschrift nach ausbuf
 bne.s kpfaus1a
 subq.l #1, a0                  * Null raus
 bsr prtcpu                     * CPU-Name nach ausbuf
 subq.l #1, a0                  * Null raus
 lea kopftxt1(pc), a1
kpfaus1b:
 move.b (a1)+, (a0)+            * berschrift 3.Teil nach ausbuf
 bne.s kpfaus1b
 subq.l #1, a0                  * Null raus
 bsr prtvers                    * Versionsnummer nach ausbuf
 lea kopftxt2(pc), a1
kpfaus1c:
 move.b (a1)+, (a0)+            * berschrift 3.Teil nach ausbuf
 bne.s kpfaus1c
 movea.l (a7)+, a1
 lea ausbuf(a5), a0             * Mit Seitenvorschub
kopfaus1:
 clr.b zeilen(a5)               * Wieder erste Zeile
 bsr prtco2                     * Text ausgeben
 addq #1,pagecnt(a5)            * Eine Seite mehr vorhanden
 lea ausbuf(a5),a0
 move pagecnt(a5),d0            * Seitennummer
 bsr print4d                    * Nummer der Seite ausgeben
 lea ausbuf(a5),a0
 bsr prtco2                     * Text ausgeben
 bsr crlfe
bra crlfe                       * Eine Zeile frei

kopftxt:
 dc.b $c
 dc.b '(C) 1991 Ralph Dombrowski / 2008 Jens Mewes ',0

kopftxt1:
 dc.b 'Assembler ',0
 
kopftxt2:
 dc.b ' Seite ',0

fintxt:
 dc.b '  Endadresse PC',$d

fin1txt:
 dc.b '  Endadresse PC + OFFSET',$d

fin2txt:
 dc.b '        Fehler entdeckt',$d,0

fin3txt:
 dc.b '  Ende-Symboltabelle / Anzahl Symbole : ',0

fin4txt:
 dc.b '        Ende-Debug-Tabelle',$d,0

 ds 0

insst equ 24                    * Start Befehlsteil

expr1:
 bsr igbn                       * Leerzeichen ignorieren
 bsr expr                       * Arithmetischen Ausdruck auswerten
 tst d1
 beq errs1                      * Syntax-Fehler
 cmp #5,d1
 beq erru1                      * Undefiniertes Symbol
rts

geteinbuf:                      * Eine Zeile holen
 clr errflag(a5)                * Kein Fehler in dieser Zeile bisher
 lea einbuf(a5),a0              * Ziel
 lea ausbuf+insst(a5),a1        * Ziel fr Ausgabe
 movea.l akttxt(a5),a2          * Zeilenanfang
 moveq #0,d1                    * Bisher kein Zeichen
getein1:
 move.b (a2)+,d0                * Zeichen holen
 bne.s getein1a                 * Nicht Null, also weiter
 moveq #$d,d0
 move #2,errflag(a5)            * Ende erreicht
getein1a:
 cmp.b #$27,d0                  * Texte
 beq.s getein2b
 cmp.b #$a,d0                   * LF ignorieren
 beq.s getein1
 cmp.b #' '-1,d0
 bhi.s getein1b
 cmp.b #$d,d0                   * CR nicht wandeln !!!
 beq.s getein1b
 moveq #' ',d0                  * Controlzeichen in Leerzeichen wandeln
getein1b:
 addq #1,d1
 cmp #131-insst,d1              * Zeilenlnge
 bpl.s getein1c
 move.b d0,(a1)+
getein1c:
 cmp #131,d1                    * Zeilenlnge
 bpl.s getein1d
 bsr bucheck                    * In Grobuchstaben wandeln
 move.b d0,(a0)+                * Ablegen
getein1d:
 cmp.b #$d,d0
bne.s getein1                   * Ende Schleife
 move.b #$d,ausbuf+131(a5)      * Sicherheitsende
 move.l a2,akttxt(a5)           * Adresse der nchsten Zeile merken
rts
getein2:
 move.b (a2)+,d0                * Text-Zeichen holen
 bne.s getein2a                 * Nicht Null, also weiter
 moveq #$d,d0
 move #2,errflag(a5)            * Ende erreicht
getein2a:
 cmp.b #$27,d0                  * Text-Ende
 beq.s getein1b
 cmp.b #$a,d0                   * LF ignorieren
 beq.s getein2
getein2b:
 addq #1,d1
 cmp #131-insst,d1              * Zeilenlnge
 bpl.s getein2c
 move.b d0,(a1)+
getein2c:
 cmp #131,d1                    * Zeilenlnge
 bpl.s getein2d
 move.b d0,(a0)+                * Ablegen (nicht in Grobuchstaben wandeln)
getein2d:
 cmp.b #$d,d0
bne.s getein2                   * Ende
 move.b #$d,ausbuf+131(a5)      * Sicherheitsende
 move.l a2,akttxt(a5)           * Adresse der nchsten Zeile merken
rts

putausbuf:                      * ausbuf ausgeben
 cmp #2,passflag(a5)            * Zweiter Durchgang ?
 bne.s putausbfi                * Nein, dann keine Ausgabe
 cmp.b #1,iostat(a5)            * Nur Fehlerausgabe ?
 bne.s putausba                 * Nein, dann Ausgabe
 tst errflag(a5)                * Fehler vorhanden ?
 beq.s putausbfi                * Nein, dann Ende
putausba:
 lea ausbuf(a5),a0              * Quelle
put1lp:
 move.b (a0)+,d0                * Zeichen holen
 beq carset                     * Ende durch Null -> Leerzeile ohne Ausgabe
 bsr co2ausa                    * Ausgabe ohne Spezialabfragen
 cmp.b #$d,d0
bne.s put1lp                    * Schleife fortsetzen, bis CR kommt
 moveq #$a,d0                   * Danach LF ausgeben
 bsr co2ausa                    * Ausgabe ohne Spezialabfragen
 move.b dflag2(a5),d0
 cmp.b zeilen(a5),d0
 beq kopfaus                    * berschrift ausgeben, falls neue Seite
putausbfi:
rts

initcode:                       * ausbuf vorbereiten
 lea ausbuf+8(a5),a0            * Ab dort gilt
 move.l a0,auspoi(a5)           * Pointer fr Ablage
 move #8,auszahl(a5)            * Anzahl der ausgegebenen Zeichen(wegen Adresse)
 moveq #insst/4-1,d1            * Anzahl
 lea ausbuf(a5),a0              * Ziel
init1c:
 move.l #'    ',(a0)+           * Vorlschen
dbra d1,init1c
 move.b #$d,(a0)+               * Endekennung
rts

putlong:
 cmp #2,passflag(a5)            * 2. Durchgang ?
 beq.s putlong1                 * Ja
 addq.l #4,pcstand(a5)          * Nein, deshalb nur PC erhhen
rts
putlong1:
 movem.l d1/a0,-(a7)            * Register retten
 cmp #insst-9,auszahl(a5)       * Abfrage, ob noch Platz
 bcs.s put1lg
 bsr newput                     * Nein, deshalb alte Zeile ausgeben und Init
put1lg:
 movea.l auspoi(a5),a0          * Zeiger auf Ausgabeadresse
 bsr print8x                    * Dort Code ablegen fr Ausgabe
 move.b #' ',(a0)+              * Danach Leerzeichen lassen
 move.l a0,auspoi(a5)           * Neuer Pointer
 add #9,auszahl(a5)             * 9 Zeichen weiter
 movea.l pcstand(a5),a0         * Zieladresse
 move a0,d1
 lsr #1,d1                      * Test, ob ungerade
 bcc.s put12lg                  * Wenn nicht, dann OK
 addq.l #1,a0                   * Sonst Adresse in Ordnung bringen
 pea einbuf(a5)
 move.l (a7)+,errpoi(a5)        * Zeiger auf Fehler
 move #1,errflag(a5)            * Fehler aufgetreten
 move #5,errart(a5)             * Art des Fehlers
 addq #1,errcnt(a5)             * Ein Fehler mehr vorhanden
put12lg:
 addq.l #4,pcstand(a5)          * PC erhhen
 adda.l offset(a5),a0           * OFFSET addieren
 move.l d0,(a0)+                * Wert ablegen
 movem.l (a7)+,d1/a0
rts

putword:                        * Wie putlong nur mit Wortausgabe
 cmp #2,passflag(a5)
 beq.s putword1
 addq.l #2,pcstand(a5)
rts
putword1:
 movem.l d1/a0,-(a7)
 movea.l auspoi(a5),a0
 cmp #insst-5,auszahl(a5)
 bcs.s put1wo
 bsr newput
put1wo:
 bsr print4x
 move.b #' ',(a0)+
 move.l a0,auspoi(a5)
 addq #5,auszahl(a5)
put2wo:
 movea.l pcstand(a5),a0
 move a0,d1
 lsr #1,d1
 bcc.s put12wo
 addq.l #1,a0
 pea einbuf(a5)
 move.l (a7)+,errpoi(a5)
 move #1,errflag(a5)
 move #5,errart(a5)
 addq #1,errcnt(a5)
put12wo:
 addq.l #2,pcstand(a5)
 adda.l offset(a5),a0
 move.w d0,(a0)+
 movem.l (a7)+,d1/a0
rts

putbyte:                        * Wie putword nur mit Byte und mit ungeraden
 cmp #2,passflag(a5)            * Adressen
 beq.s putbyte1
 addq.l #1,pcstand(a5)
rts
putbyte1:
 movem.l d1/a0,-(a7)
 movea.l auspoi(a5),a0
 cmp #insst-3,auszahl(a5)
 bcs.s put1by
 bsr.s newput
put1by:
 bsr print2x
 move.b #' ',(a0)+
 addq #3,auszahl(a5)
put2by:
 move.l a0,auspoi(a5)
 movea.l pcstand(a5),a0
 addq.l #1,pcstand(a5)
 adda.l offset(a5),a0
 move.b d0,(a0)+
 movem.l (a7)+,d1/a0
rts

putobyte:                       * Wie putbyte ohne Leerzeichen nach Ausgabe
 cmp #2,passflag(a5)
 beq.s puto1byte
 addq.l #1,pcstand(a5)
rts
puto1byte:
 movem.l d1/a0,-(a7)
 movea.l auspoi(a5),a0
 cmp #insst-3,auszahl(a5)
 bcs.s put1oby
 bsr.s newput
put1oby:
 bsr print2x
 move.b #' ',(a0)
 addq #2,auszahl(a5)
bra.s put2by

newput:
 move.l d0,-(a7)
 bsr putausbuf                  * Alte Zeile ausgeben
 bsr initcode                   * Init Buffer
 bsr.s getq1                    * Adresse ausgeben
 move.l (a7)+,d0
 addq.l #2,a0                   * a0 zwei Zeichen hinter Adresse
rts

getquelle:
 bsr putausbuf                  * Alte Zeile ausgeben
 bsr initcode                   * Init ausbuf
 bsr geteinbuf                  * Neue Zeile holen
getq1:
 move.l pcstand(a5),d0
 lea ausbuf(a5),a0
 bsr print6x                    * Adresse ausgeben
 move.b #' ',(a0)               * Null am Ende berschreiben
rts

absl   equ  $2000               * Codierung der einzelnen Adressierungsarten
absw   equ  $1000               * Jede Art hat ihr eigenes Bit
indir  equ  $0800               * Dadurch sind auch Kombinationen in der Abfrage
decre  equ  $0400               * und Erstellung mglich
incre  equ  $0200
dreg   equ  $0100
areg   equ  $0080
displ  equ  $0040
pcadr  equ  $0020
indx   equ  $0010

* d0 = ist Datenwert, falls einer vorhanden
* d2 = Modecode nach A68K
* d3 = Extensioncode fr Index-Mode
* d4 = Bitcode

getea:                          * Adressierungsart feststellen
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #'-',(a0)                * Predecrement
 bne.s getea1
 cmp.b #'(',1(a0)               * Dann mu Klammer folgen
 bne getea5                     * Nicht, dann nur negative Zahl mglich
 addq.l #2,a0
 bsr checkan                    * Adressregister mu folgen
 bcs getea50                    * Sonst nur Klammerrechnung mglich
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #')',(a0)
 bne errs1                      * Wenn nicht Klammer zu, dann Fehler
 addq.l #1,a0
 move d5,d2                     * Registernummer nach d2
 or #%100000,d2                 * Und Code dazu
 move #decre,d4                 * Adressierungsart ist decrement
rts

getea1:                         * Indirekt oder Postincrement
 cmp.b #'(',(a0)                * Klammer auf am Anfang
 bne.s getea3                   * Nein, dann weiter
 addq.l #1,a0
 bsr checkan                    * Jetzt mu Adressregister folgen
 bcs.s getea501                 * Sonst nur Klammerrechnung mglich
 bsr igbn
 cmp.b #')',(a0)                * Klammer zu mu kommen
 bne errs1                      * Sonst Fehler
 addq.l #1,a0
 cmp.b #'+',(a0)                * Jetzt Entscheidung ob postincrement
 bne.s getea2                   * Nein, dann weiter
 addq.l #1,a0
 move d5,d2                     * Register
 or #%011000,d2                 * Plus Mode
 move #incre,d4                 * Adressierungsart ist postincrement
rts

getea2:                         * Indirekt
 move d5,d2                     * Register
 or #%010000,d2                 * Mode
 move #indir,d4                 * Adressierungsart ist indirekt
rts

getea3:                         * Keine Klammer am Anfang
 bsr checkdn                    * Vielleicht Datenregister
 bcs.s getea4                   * Nein
 move d5,d2                     * Ja, Registernummer nach d2
 move #dreg,d4                  * Register direkt
rts

getea4:
 bsr checkan                    * Vielleicht Adressregister
 bcs.s getea5                   * Nein
 move d5,d2                     * Nummer
 or #%001000,d2                 * Mode
 move #areg,d4                  * Adressregister direkt
rts

getea50:
 subq.l #1,a0
getea501:
 subq.l #1,a0
getea5:
 bsr expr1                      * Arithmetischen Ausdruck auswerten
 tst d1
 beq carset                     * Syntax-Fehler
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #'(',(a0)
 beq.s getea6                   * Jetzt kann Klammer folgen
 cmp.b #'.',(a0)
 bne.s getea53                  * Oder Grenangabe
 addq.l #1,a0
 cmp.b #'L',(a0)                * Langwort ?
 beq.s getea52
 cmp.b #'W',(a0)                * Oder Wort
 beq.s getea51
 cmp.b #'S',(a0)                * W oder S ist egal
 bne errs1                      * Sonst Fehler
getea51:
 addq.l #1,a0                   * Wort-Gre
 move #absw,d4                  * Adressierungsart ist absolut kurz
 moveq #%111000,d2              * Mode
rts

getea52:
 addq.l #1,a0
getea53:
 move #absl,d4                  * Adressierungsart ist absolut lang
 moveq #%111001,d2              * Mode
rts

getea6:
 addq.l #1,a0                   * Mit Klammer nach Wert
 bsr igbn
 cmp.b #'P',(a0)                * PC-relativ ?
 bne.s getea62                  * Nein
 cmp.b #'C',1(a0)
 bne.s getea62                  * Nein
 addq.l #2,a0
 bsr igbn
 cmp.b #',',(a0)                * Danach noch ein Register ?
 beq.s getea61                  * Ja
 cmp.b #')',(a0)                * Klammer zu mu folgen
 bne errs1                      * Sonst Fehler
 addq.l #1,a0
 move #displ!pcadr!indir,d4     * Adressierungsart ist PC-relativ mit Displacemt
 moveq #%111010,d2              * Mode
rts

getea61:
 addq.l #1,a0
 move #displ!pcadr!indir!indx,d4* Adressierungsart ist PC-relativ mit Displacemt
 moveq #%111011,d2              * und Index
bra.s getea64

getea62:
 bsr checkan                    * Nicht PC-relativ also dann Adressregister
 bcs errs1                      * Fehler
 move d5,d2                     * Nummer merken
 bsr igbn
 cmp.b #',',(a0)                * Wenn nicht ',', dann OK
 beq.s getea63
 cmp.b #')',(a0)                * Dann mu aber auch Klammer folgen
 bne errs1
 addq.l #1,a0
 move #displ!indir,d4           * Adressierungsart ist Adressregister indirekt
 or #%101000,d2                 * Mit Displacement
rts

getea63:
 addq.l #1,a0
 move #displ!indir!indx,d4      * Jetzt Indirekt mit Displacement und Index
 or #%110000,d2

getea64:
 bsr.s checkan                  * Also mu jetzt ein Register folgen
 bcs.s getea65                  * Nicht Adressregister
 move d5,d3                     * Nummer Adressregister
 ror #4,d3                      * An richtige Stelle
 or #$8000,d3                   * Und Bit, da Adressregister
 bra.s getea66                  * OK, jetzt weiter testen
getea65:
 bsr.s checkdn                  * Es mu jetzt Datenregister sein
 bcs errs1                      * Fehler
 move d5,d3
 ror #4,d3                      * Nummer an richtige Stelle
getea66:
 cmp.b #'.',(a0)                * Lngenangabe ?
 bne.s getea68                  * Nein
 addq.l #1,a0                   * Ja, also mu W oder L folgen
 cmp.b #'W',(a0)
 beq.s getea67                  * Es ist W
 cmp.b #'L',(a0)
 bne errs1                      * Nicht W oder L, also Fehler
 or #$0800,d3                   * Es ist L
getea67:
 addq.l #1,a0
getea68:
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #')',(a0)+               * Jetzt mu Klammer folgen
 beq carres                     * OK
 subq.l #1,a0
bra errs1                       * Fehler

kommack:                        * Test, ob Komma folgt
 bsr igbn                       * Ohne Leerzeichen
 cmp.b #',',(a0)
 bne errs1                      * Kein Komma, also Fehler
 addq.l #1,a0                   * OK, also a0 erhhen
rts

checkan:                        * Test, ob Adressregister
 bsr igbn
 cmp.b #'A',(a0)
 bne carset                     * Nein
bra.s checkda                   * Ja, jetzt Nummer holen

checkdn:                        * Test, ob Datenregister
 bsr igbn
 cmp.b #'D',(a0)
 bne carset                     * Nein
checkda:
 cmp.b #'0',1(a0)               * Es ist Register, deshalb Nummer holen
 bcs carset                     * Fehler
 cmp.b #'7'+1,1(a0)
 bcc carset                     * Fehler
 addq.l #1,a0                   * Zahl ist OK
 move.b (a0)+,d5                * ASCII-Zeichen holen
 and #7,d5                      * Wandeln
bra carres                      * OK

putorea:                        * Aus Befcode und d2 Mode bilden und ausgeben
 move d0,-(a7)
 move d6,d0
 or d2,d0                       * Verodern
 bsr putword                    * Ausgeben
 move (a7)+,d0
rts

codea:
 bsr.s putorea                  * Befehlscode und Adressmode verknpft ausgeben

putea:                          * Adressierungsart ausgeben
 move d2,d5                     * Adressierungsart merken
 and.b #%111000,d5              * Nur Mode, ohne Register
 cmp.b #%101000,d5
 bne.s *+10                     * Wort ausgeben
 bsr rangewck
bra putword

 cmp.b #%110000,d5
 bne.s put1ea
 bsr rangebck
 and #$ff,d0
 or d3,d0
bra putword                     * Displacement ausgeben  ( Ist nur Byte )

put1ea:
 cmp.b #%111000,d2
 beq putword                    * Absolut Kurz (Wort)

 cmp.b #%111001,d2
 beq putlong                    * Absolut Lang (Langwort)

 cmp.b #%111010,d2
 bne.s put2ea
 sub.l pcstand(a5),d0           * PC relativ / d(pc)
 bsr rangew1ck                  * Bereich testen
bra putword                     * Wort ausgeben

put2ea:
 cmp.b #%111011,d2
 bne carres
 sub.l pcstand(a5),d0           * PC mit Displacement / d(pc,rx)
 bsr rangeb1ck                  * Bereichstest
 and #$ff,d0
 or d3,d0                       * Nur Byte
bra putword                     * Displacement ausgeben ( Ist nur Byte )

assline:                        * Eine Zeile bersetzen
 bsr co2test                    * Ctrl-C, Ctrl-S, Ctrl-Q oder <Space>
 bcs abbruch
 cmp #2,errflag(a5)             * Ende
 beq carres                     * Ja
 move.l pcstand(a5),anfstand(a5)* PC merken
 lea einbuf(a5),a0              * Quelle der Zeile
 bsr igbn                       * Leerzeichen ignorieren
 move.l a0,-(a7)
 bsr setupname                  * Ist es ein Name ?
 bcs assline5                   * Nein !
 cmp.b #':',(a0)                * Ja, dann kann ':' folgen
 bne.s assline2                 * Nicht, dann vielleicht EQU
 addq.l #4,a7                   * Stack reinigen
 addq.l #1,a0                   * ':' berspringen
 movem.l d2/d3/a0,-(a7)         * Register retten
 bsr setigname                  * Nchster Name
 move.l d2,d4                   * Namen merken
 movem.l (a7)+,d2/d3/a0         * Register zurck
 move.l d2,nametab(a5)          * Namen zurck
 move.l d3,nametab+4(a5)
 cmp.l #'RS  ',d4               * RS-Anweisung ?
 beq codrs                      * Ja, dann auswerten
 move.l pcstand(a5),d0          * Das ist Wert fr Zuweisung
 moveq #3,d1                    * Als Langwort definiert
 bsr newval                     * Symbol setzen, wenn neu
 bcc.s assline1                 * OK, eingetragen
 cmp.l datenwert(a3),d0         * Ist schon definiert, deshalb Vergleich, ob
 bsr errnmult                   * es der selbe Wert ist, wenn nein, dann Fehler
 move.l d0,datenwert(a3)        * Jetzt mit neuem Wert eintragen
 move d1,attribut(a3)           * Als Langwort
assline1:
 bsr igbn
bra.s assline6                  * Weiter, vielleicht folgt noch etwas
assline2:
 move.l d2,d4                   * Namen
 move.l d3,d5                   * merken
 bsr setigname                  * Jetzt weiter testen
 bcs.s assline5                 * Weiter, da kein Name folgt
 moveq #0,d7                    * Kennung EQU
 cmp.l #'EQU ',d2               * Kommt eine EQU-Definition ?
 beq.s assline3                 * Ja
 cmp.l #'NEWE',d2               * Kommt eine NEWEQU-Definition ?
 bne.s assline5                 * Nein
 cmp.l #'QU  ',d3
 bne.s assline5                 * Nein
 moveq #1,d7                    * Kennung NEWEQU
assline3:
 bsr expr1                      * Ja, deshalb jetzt arithmetischen Ausdruck
 move.l d4,d2                   * berechnen
 move.l d5,d3
 move.l a0,(a7)                 * a0 auf Stand bringen
 lea ausbuf(a5),a0
 move #'= ',(a0)+
 bsr print8x                    * Fr Ausgabe
 move.b #' ',(a0)               * Null berschreiben
 movea.l (a7)+,a0
 move.l d2,nametab(a5)          * Namen abspeichern
 move.l d3,nametab+4(a5)
 bsr newval                     * Und in Symboltabelle eintragen
 bcc.s assline7                 * OK
 tst d7                         * NEWEQU ?
 bne.s assline4                 * Ja, dann nur berschreiben
 cmp.l datenwert(a3),d0
 bsr errnmult                   * Mehrfach definiert
assline4:
 move.l d0,datenwert(a3)        * Schon vorhanden, deshalb einfach berschreiben
 move d1,attribut(a3)           * Lnge eintragen
bra.s assline7

assline5:
 movea.l (a7)+,a0               * a0 zurck
assline6:
 cmp.b #'.',(a0)
 beq macro
 cmp.b #$d,(a0)
 beq.s assline8                 * Ende
 cmp.b #'*',(a0)
 beq.s assline8                 * Ende
 cmp.b #';',(a0)
 beq.s assline8                 * Ende
 bsr verteile                   * Sonst Befehl auswerten
 cmp #2,errflag(a5)
 beq carres                     * Ende wenn END
assline7:
 cmp #2,passflag(a5)            * Alles folgende nur beim zweiten Durchlauf
 bne carres
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #$d,(a0)
 beq.s assline9                 * Ende
 cmp.b #'*',(a0)
 beq.s assline9                 * Ende
 cmp.b #';',(a0)
 beq.s assline9                 * Ende
 bsr errs1                      * Fehler
bra erranalyse                  * Und Fehleranalyse
assline8:
 cmp #2,passflag(a5)
 bne carres                     * Beim ersten Durchlauf Ende
assline9:
 tst errflag(a5)
 bne erranalyse                 * Fehler, deshalb Auswertung
rts

checkcc:                        * Bedingung testen und berechnen der Bits
 move.b (a0),d0                 * Ersten Wert holen
 bsr bucheck                    * Mu Buchstabe sein
 bcs errs1                      * Sonst Fehler
 asl #8,d0                      * Verschieben
 move d0,d1                     * Und merken
 move.b 1(a0),d0                * Nchsten Wert holen
 bsr bucheck                    * Kann auch Buchstabe sein
 bcs.s checkcc1                 * Wenn nicht, dann OK
 or d0,d1                       * Sonst zu einem Wort verbinden
 move.b 2(a0),d0                * Nchsten Wert holen
 bsr bucheck                    * Darf nicht mehr Buchstabe sein
 bcc errs1                      * Sonst Fehler
 addq.l #2,a0                   * a0 erhhen
bra.s checkcc2
checkcc1:
 addq.l #1,a0                   * a0 erhhen
 move.b #' ',d1                 * Zweiter Buchstabe ist Leerzeichen
checkcc2:
 lea cctab(pc),a1               * Adresse Tabelle
 moveq #16-1,d6                 * 18 Werte prfen
checkcc3:
 cmp (a1)+,d1                   * Vergleich
 beq.s checkcc4                 * OK, gefunden
dbra d6,checkcc3                * Nchsten Wert suchen
 moveq #%0100,d6
 cmp #'HS',d1                   * HS
 beq.s checkcc4
 moveq #%0101,d6
 cmp #'LO',d1                   * und LO extra
 bne errs1                      * Fehler, nicht gefunden
checkcc4:
 lsl #8,d6
rts

cctab:                          * Tabelle der Bedingungen
 dc.b 'LE'
 dc.b 'GT'
 dc.b 'LT'
 dc.b 'GE'
 dc.b 'MI'
 dc.b 'PL'
 dc.b 'VS'
 dc.b 'VC'
 dc.b 'EQ'
 dc.b 'NE'
 dc.b 'CS'
 dc.b 'CC'
 dc.b 'LS'
 dc.b 'HI'
 dc.b 'F '
 dc.b 'T '

checkno:                        * Fehler, wenn Grenangabe
 bsr.s setsbw                   * Gre holen
 bcs errsize                    * Fehler
rts

checkb:                         * Fehler, wenn nicht Byte
 bsr.s setsbw
 bcc.s checksifi                * Wenn keine Angabe, dann OK
 tst wordbyte(a5)
 bne errsize
rts

checkw:                         * Fehler, wenn nicht Wort
 bsr.s setsbw
 bcc.s checksifi                * Wenn keine Angabe, dann OK
 cmp #1,wordbyte(a5)
 bne errsize
rts

checkl:                         * Fehler, wenn nicht Long
 bsr.s setsbw
 bcc.s checksifi                * Wenn keine Angabe, dann OK
 cmp #2,wordbyte(a5)
 bne errsize
rts

checkbw:                        * Fehler, wenn nicht Byte oder Wort
 bsr.s setsbw
 bcc.s checkwset
 cmp #1,wordbyte(a5)
 beq.s checksifi
 tst wordbyte(a5)
 bne errsize
rts

checkwl:                        * Fehler, wenn nicht Wort oder Long
 bsr.s setsbw
 bcc.s checkwset
 cmp #1,wordbyte(a5)
 beq.s checksifi
 cmp #2,wordbyte(a5)
 bne errsize
rts

checkbwl:                       * Alles erlaubt
 bsr.s setsbw                   * Setzt auf Wort, wenn keine Angabe
 bcs.s checksifi
checkwset:                     * Wenn keine Angabe, dann Wort
 move #1,wordbyte(a5)
checksifi:
rts

setsbw:                         * Gre holen
 move #3,wordbyte(a5)           * Voreinstellung keine Gre
 cmp.b #'.',(a0)                * Nur nach '.' kann Grenangabe kommen
 bne carres
 cmp.b #'S',1(a0)               * Vielleicht 'S'
 beq.s setsbw1
 cmp.b #'B',1(a0)               * Oder 'B'
 bne.s setsbw2
setsbw1:
 addq.l #2,a0
 clr wordbyte(a5)               * Nur Byte
bra carset
setsbw2:
 cmp.b #'L',1(a0)               * 'L' ?
 bne.s setsbw3
 addq.l #2,a0                   * Ja
 move #2,wordbyte(a5)           * Langwort
bra carset
setsbw3:
 cmp.b #'W',1(a0)               * Oder 'W'
 bne.s setsbw4                  * Nein, dann Fehler
 addq.l #2,a0
 move #1,wordbyte(a5)           * Wort
bra carset
setsbw4:
 bsr errs1                      * Syntaxfehler
bra carres                      * Keine Gre

symcode equ 8
symtype equ 8+2
symadr  equ 8+2+2
symlg   equ 8+2+2+2

verteile:                       * Befehl auswerten
 move.l a0,d6
 bsr setupname
 bcs errs1                      * Fehler
 moveq #1,d0                    * Erster Befehl
 moveq #symzahl,d1              * Letzter Befehl
suchkey:
 move d0,d4                     * Erster Wert
 add d1,d4                      * Letzter Wert
 lsr #1,d4                      * Arithmetisches Mittel bilden
 move d4,d7
 mulu #symlg,d7                 * Lnge eines Eintrags
 lea befehle-symlg(pc,d7.w),a3  * Adresse Befehl
 cmp.l (a3)+,d2                 * Vergleich
 bmi.s suchkl1                  * Kleiner
 bhi.s suchgr1                  * Grer
 cmp.l (a3),d3                  * Zweiter Teil
 bmi.s suchkl1                  * Kleiner
 bhi.s suchgr1                  * Grer
 move symcode-4(a3),d6          * Code fr Befehl
 move symtype-4(a3),attcode(a5) * Alternativ
 move symadr-4(a3),d0           * Adresse berechnen
jmp befehle(pc,d0)              * Und aufrufen

suchkl1:                        * Ist kleiner
 subq #1,d4
 move d4,d1                     * Also im ersten Teil weitersuchen
 cmp d0,d1                      * Letzen Wert geprft
 bpl.s suchkey
bra.s verteil0                  * Nicht gefunden

suchgr1:                        * Ist grer
 addq #1,d4
 move d4,d0                     * Also im zweiten Teil weitersuchen
 cmp d0,d1                      * Letzten Wert geprft
 bpl.s suchkey
                                * Nicht gefunden
verteil0:
 movea.l d6,a0                  * Nicht gefunden, deshalb spezieller Test
 cmp.b #'S',(a0)                * Folgt 'S'
 bne.s verteil1                 * Nein
 addq.l #1,a0
 bsr checkcc                    * Test, ob Bedingung
 or #%0101000011000000,d6       * Code fr SCC
bra codtas                      * Und Befehl auswerten

verteil1:
 cmp.b #'B',(a0)               * Ist es BCC ?
 bne.s verteil2                 * Nein
 addq.l #1,a0
 bsr checkcc                    * Bedingungen holen
 or #%0110000000000000,d6       * Code fr BCC
bra codbra                      * Auswerten

verteil2:
 cmp.b #'D',(a0)                * Jetzt kann es nur noch dbra sein
 bne errs1                      * oder Fehler
 cmp.b #'B',1(a0)
 bne errs1                      * Fehler
 addq.l #2,a0
 bsr checkcc                    * Bedingung holen
 or #%0101000011001000,d6       * Code fr dbcc
bra coddbcc                     * Auswerten

befehle:                        * Tabelle der Befehle
 dc.b 'ABCD    '                * Befehl
 dc.w %1100000100000000         * Code
 dc.w 0                         * Alternativcode ( add/addi )
 dc.w codabcd-befehle           * Adresse

 dc.b 'ADD     '
 dc.w %1101000000000000
 dc.w %0000011000000000         * Addi
 dc.w codadd-befehle

 dc.b 'ADDA    '
 dc.w %1101000011000000
 dc.w 0
 dc.w codadda-befehle

 dc.b 'ADDI    '
 dc.w %0000011000000000
 dc.w 0
 dc.w codaddi-befehle

 dc.b 'ADDQ    '
 dc.w %0101000000000000
 dc.w 0
 dc.w codaddq-befehle

 dc.b 'ADDX    '
 dc.w %1101000100000000
 dc.w 0
 dc.w codaddx-befehle

 dc.b 'AND     '
 dc.w %1100000000000000
 dc.w %0000001000000000         * andi
 dc.w codand-befehle

 dc.b 'ANDI    '
 dc.w %0000001000000000
 dc.w 0
 dc.w codeori-befehle

 dc.b 'ASL     '
 dc.w %1110000100000000
 dc.w %1110000111000000
 dc.w codshift-befehle

 dc.b 'ASR     '
 dc.w %1110000000000000
 dc.w %1110000011000000
 dc.w codshift-befehle

 dc.b 'BCHG    '
 dc.w %0000000101000000
 dc.w %0000100001000000
 dc.w codbchg-befehle

 dc.b 'BCLR    '
 dc.w %0000000110000000
 dc.w %0000100010000000
 dc.w codbchg-befehle

 dc.b 'BRA     '
 dc.w %0110000000000000
 dc.w 0
 dc.w codbra-befehle

 dc.b 'BSET    '
 dc.w %0000000111000000
 dc.w %0000100011000000
 dc.w codbchg-befehle

 dc.b 'BSR     '
 dc.w %0110000100000000
 dc.w 0
 dc.w codbra-befehle

 dc.b 'BTST    '
 dc.w %0000000100000000
 dc.w %0000100000000000
 dc.w codbtst-befehle

 dc.b 'CHK     '
 dc.w %0100000110000000
 dc.w 0
 dc.w codchk-befehle

 dc.b 'CLR     '
 dc.w %0100001000000000
 dc.w 0
 dc.w codneg-befehle

 dc.b 'CMP     '
 dc.w %1011000000000000
 dc.w %0000110000000000         * cmpi
 dc.w codcmp-befehle

 dc.b 'CMPA    '
 dc.w %1011000011000000
 dc.w 0
 dc.w codadda-befehle

 dc.b 'CMPI    '
 dc.w %0000110000000000
 dc.w 0
 dc.w codaddi-befehle

 dc.b 'CMPM    '
 dc.w %1011000100001000
 dc.w 0
 dc.w codcmpm-befehle

 dc.b 'CO2SER  '                * Ausgabe ber serielle Schnittstelle
 dc.w 6
 dc.w 0
 dc.w ausmode-befehle

 dc.b 'CRT     '                * Ausgabe auf Bildschirm
 dc.w 2
 dc.w 0
 dc.w ausmode-befehle

 dc.b 'DBRA    '
 dc.w %0101000111001000
 dc.w 0
 dc.w coddbcc-befehle

 dc.b 'DC      '
 dc.w 0
 dc.w 0
 dc.w coddc-befehle

 dc.b 'DEBUGAN '                * Debug anschalten
 dc.w 0
 dc.w 0
 dc.w debugon-befehle

 dc.b 'DEBUGAUS'                * Debug ausschalten
 dc.w 0
 dc.w 0
 dc.w debugoff-befehle

 dc.b 'DF      '
 dc.w 0
 dc.w 0
 dc.w coddf-befehle

 dc.b 'DIVS    '
 dc.w %1000000111000000
 dc.w 0
 dc.w codmuls-befehle

 dc.b 'DIVU    '
 dc.w %1000000011000000
 dc.w 0
 dc.w codmuls-befehle

 dc.b 'DS      '
 dc.w 0
 dc.w 0
 dc.w codds-befehle

 dc.b 'END     '
 dc.w 0
 dc.w 0
 dc.w codend-befehle

 dc.b 'EOR     '
 dc.w %1011000100000000
 dc.w %0000101000000000         * eori
 dc.w codeor-befehle

 dc.b 'EORI    '
 dc.w %0000101000000000
 dc.w 0
 dc.w codeori-befehle

 dc.b 'EXG     '
 dc.w %1100000100000000
 dc.w 0
 dc.w codexg-befehle

 dc.b 'EXT     '
 dc.w %0100100000000000
 dc.w 0
 dc.w codext-befehle

 dc.b 'ILLEGAL '
 dc.w %0100101011111100
 dc.w 0
 dc.w codall-befehle

 dc.b 'JMP     '
 dc.w %0100111011000000
 dc.w 0
 dc.w codjmp-befehle

 dc.b 'JSR     '
 dc.w %0100111010000000
 dc.w 0
 dc.w codjmp-befehle

 dc.b 'LEA     '
 dc.w %0100000111000000
 dc.w 0
 dc.w codlea-befehle

 dc.b 'LINK    '
 dc.w %0100111001010000
 dc.w 0
 dc.w codlink-befehle

 dc.b 'LSL     '
 dc.w %1110000100001000
 dc.w %1110001111000000
 dc.w codshift-befehle

 dc.b 'LSR     '
 dc.w %1110000000001000
 dc.w %1110001011000000
 dc.w codshift-befehle

 dc.b 'LST     '                * Ausgabe auf Drucker
 dc.w 3
 dc.w 0
 dc.w ausmode-befehle

 dc.b 'MACRO   '
 dc.w 1
 dc.w 0
 dc.w defmacro-befehle

 dc.b 'MOVE    '
 dc.w %0000000000000000
 dc.w 0
 dc.w codmove-befehle

 dc.b 'MOVEA   '
 dc.w %0010000001000000
 dc.w 0
 dc.w codmovea-befehle

 dc.b 'MOVEC   '
 dc.w %0100111001111010
 dc.w 0
 dc.w codmovec-befehle

 dc.b 'MOVEM   '
 dc.w %0100100010000000
 dc.w 0
 dc.w codmovem-befehle

 dc.b 'MOVEP   '
 dc.w %0000000000001000
 dc.w 0
 dc.w codmovep-befehle

 dc.b 'MOVEQ   '
 dc.w %0111000000000000
 dc.w 0
 dc.w codmoveq-befehle

 dc.b 'MOVES   '
 dc.w %0000111000000000
 dc.w 0
 dc.w codmoves-befehle

 dc.b 'MULS    '
 dc.w %1100000111000000
 dc.w 0
 dc.w codmuls-befehle

 dc.b 'MULU    '
 dc.w %1100000011000000
 dc.w 0
 dc.w codmuls-befehle

 dc.b 'NBCD    '
 dc.w %0100100000000000
 dc.w 0
 dc.w codtas-befehle

 dc.b 'NEG     '
 dc.w %0100010000000000
 dc.w 0
 dc.w codneg-befehle

 dc.b 'NEGX    '
 dc.w %0100000000000000
 dc.w 0
 dc.w codneg-befehle

 dc.b 'NEWMACRO'
 dc.w 0
 dc.w 0
 dc.w defmacro-befehle

 dc.b 'NIL     '                * Ausgabe abschalten
 dc.w 1
 dc.w 0
 dc.w ausmode-befehle

 dc.b 'NOP     '
 dc.w %0100111001110001
 dc.w 0
 dc.w codall-befehle

 dc.b 'NOT     '
 dc.w %0100011000000000
 dc.w 0
 dc.w codneg-befehle

 dc.b 'OFFSET  '
 dc.w 0
 dc.w 0
 dc.w codoff-befehle

 dc.b 'OR      '
 dc.w %1000000000000000
 dc.w %0000000000000000         * ori
 dc.w codand-befehle

 dc.b 'ORG     '
 dc.w 0
 dc.w 0
 dc.w codorg-befehle

 dc.b 'ORI     '
 dc.w %0000000000000000
 dc.w 0
 dc.w codeori-befehle

 dc.b 'PEA     '
 dc.w %0100100001000000
 dc.w 0
 dc.w codpea-befehle

 dc.b 'RESET   '
 dc.w %0100111001110000
 dc.w 0
 dc.w codall-befehle

 dc.b 'ROL     '
 dc.w %1110000100011000
 dc.w %1110011111000000
 dc.w codshift-befehle

 dc.b 'ROR     '
 dc.w %1110000000011000
 dc.w %1110011011000000
 dc.w codshift-befehle

 dc.b 'ROXL    '
 dc.w %1110000100010000
 dc.w %1110010111000000
 dc.w codshift-befehle

 dc.b 'ROXR    '
 dc.w %1110000000010000
 dc.w %1110010011000000
 dc.w codshift-befehle

 dc.b 'RS      '
 dc.w 0
 dc.w 0
 dc.w codrsin-befehle

 dc.b 'RSRESET '
 dc.w 0
 dc.w 0
 dc.w codrsreset-befehle

 dc.b 'RSSET   '
 dc.w 0
 dc.w 0
 dc.w codrsset-befehle

 dc.b 'RTD     '
 dc.w %0100111001110100
 dc.w 0
 dc.w codstop-befehle           * Wie stop behandeln

 dc.b 'RTE     '
 dc.w %0100111001110011
 dc.w 0
 dc.w codall-befehle

 dc.b 'RTR     '
 dc.w %0100111001110111
 dc.w 0
 dc.w codall-befehle

 dc.b 'RTS     '
 dc.w %0100111001110101
 dc.w 0
 dc.w codall-befehle

 dc.b 'SBCD    '
 dc.w %1000000100000000
 dc.w 0
 dc.w codabcd-befehle

 dc.b 'STOP    '
 dc.w %0100111001110010
 dc.w 0
 dc.w codstop-befehle

 dc.b 'SUB     '
 dc.w %1001000000000000
 dc.w %0000010000000000         * subi
 dc.w codadd-befehle

 dc.b 'SUBA    '
 dc.w %1001000011000000
 dc.w 0
 dc.w codadda-befehle

 dc.b 'SUBI    '
 dc.w %0000010000000000
 dc.w 0
 dc.w codaddi-befehle

 dc.b 'SUBQ    '
 dc.w %0101000100000000
 dc.w 0
 dc.w codaddq-befehle

 dc.b 'SUBX    '
 dc.w %1001000100000000
 dc.w 0
 dc.w codaddx-befehle

 dc.b 'SWAP    '
 dc.w %0100100001000000
 dc.w 0
 dc.w codswap-befehle

 dc.b 'SYMCLR  '                * Symboltabelle lschen
 dc.w 0
 dc.w 0
 dc.w symclr-befehle

 dc.b 'TAS     '
 dc.w %0100101011000000
 dc.w 0
 dc.w codtas-befehle

 dc.b 'TRAP    '
 dc.w %0100111001000000
 dc.w 0
 dc.w codtrap-befehle

 dc.b 'TRAPV   '
 dc.w %0100111001110110
 dc.w 0
 dc.w codall-befehle

 dc.b 'TST     '
 dc.w %0100101000000000
 dc.w 0
 dc.w codneg-befehle

 dc.b 'UNLK    '
 dc.w %0100111001011000
 dc.w 0
 dc.w codunlk-befehle

 dc.b 'USR     '
 dc.w 5
 dc.w 0
 dc.w ausmode-befehle

lastsym:
symzahl equ (lastsym-befehle)/symlg     * Anzahl der Befehle

*** MACRO-Verarbeitung ***

defmacro:
 bsr setigname                  * Namen des Macros holen
 bcc.s defmacr0                 * OK, Name richtig definiert
 bsr errs1                      * Syntax-Fehler
 bsr assline7                   * Fehler ausgeben
 moveq #1,d5                    * Fehler bei Macro-Definition
bra.s defmacr4                  * Nur Ende suchen
defmacr0:
 moveq #0,d5                    * OK, Macroname in Ordnung
 movea.l macrotab(a5),a1        * Tabelle der Macros
 movea.l a1,a3                  * Adresse merken
 move (a3)+,d0                  * Anzahl
 beq.s defmacr3                 * Null, dann OK
defmacr1:
 cmp.l (a3)+,d2                 * Vergleich, ob Macro schon vorhanden
 bne.s defmacr2                 * Nein, dann weitersuchen
 cmp.l (a3),d3
 bne.s defmacr2                 * Nein, dann weitersuchen
 subq.l #4,a3                   * Pointer zurck
 subq #1,(a1)                   * Ausgleich fr unten, da schon vorhanden
 tst d6
 bsr errnmult                   * Mehrfach definiert, wenn d6 <> 0
bra.s defmacr3                  * Weiter
defmacr2:
 adda #12,a3                    * Pointer auf nchsten Namen
 subq #1,d0                     * Nchster Macro
 bne.s defmacr1                 * Schleife
defmacr3:
 addq #1,(a1)                   * Ein Macro mehr vorhanden
 move (a1)+,d0                  * Anzahl holen
 muls #16,d0                    * Mal Lnge eines Eintrags
 adda.l d0,a1                   * Plus Anfangsadresse der Macrotabelle+2
 move.l a1,macroanf(a5)         * Macro-Anfang neu festlegen (Ans Ende Macrotab)
 move.l d2,(a3)+                * Neuen Macro eintragen (Oder berschreiben)
 move.l d3,(a3)+
 move.l akttxt(a5),(a3)+        * Anfangsadresse des Macro
 bsr assline7                   * Zeilenende ? (Fehler, wenn noch etwas folgt)
 moveq #-1,d7                   * Keine Zeile bisher
defmacr4:
 bsr co2test                    * Extraabfrage fr Abbruch
 bcs abbruch
 bsr getquelle                  * Zeile holen und Alte ausgeben
 cmp #2,errflag(a5)
 bne.s *+10
 lea txtmacro(pc),a0
bra errabbr                     * Ende Text und kein Ende Macro -> Abbruch
 addq #1,d7                     * Eine Zeile mehr vorhanden
 lea einbuf(a5),a0              * Zeilenanfang
 bsr setigname                  * Namen holen
 bcs.s defmacr4                 * Fehler
 cmp.l #'ENDM',d2
 bne.s defmacr4                 * Kein Ende
 cmp.l #'ACRO',d3
 bne.s defmacr4                 * Kein Ende
 tst d5
 bne.s defmacr5                 * Nicht abspeichern, da kein Name vorhanden
 move d7,(a3)+                  * Anzahl Zeilen merken
 clr (a3)+                      * Bisher kein Aufruf
 cmp #2,passflag(a5)
 beq.s defmacr5                 * Bei zweitem Durchgang weiter
 cmpa.l debugst(a5),a3          * Wenn berlagerung Macro-Tabelle mit
 bmi.s defmacr5                 * Debug-Tabelle, dann Debug-Tabelle verschieben
 move.l a3,debugst(a5)          * Debug-Anfang neu festlegen
 move.l a3,debugak(a5)
defmacr5:
rts

macro:                          * Macro bersetzen
 movea.l a0,a1                  * Adresse merken
 addq.l #1,a0                   * '.' berspringen
 bsr setupname                  * Namen holen
 bcc.s macro0                   * OK, dann weiter
 bsr errs1                      * Syntax-Fehler
bra assline7                    * Ende der Zeile bearbeiten
macro0:
 movea.l macrotab(a5),a2        * Adresse der Definitionstabelle
 move (a2)+,d0                  * Anzahl der Macros
 bne.s macro1                   * Nicht Null, dann Macro suchen
 bsr erru1                      * Undefiniert
bra assline7                    * Ende der Zeile bearbeiten
macro1:
 cmp.l (a2)+,d2                 * Macro suchen
 bne.s macro2                   * Nicht gefunden
 cmp.l (a2),d3
 beq.s macro3                   * OK, gefunden
macro2:
 adda #12,a2                    * Zum nchsten Eintrag
 subq #1,d0                     * Weitersuchen, falls noch
bne.s macro1                    * ein Eintrag vorhanden ist
 bsr erru1                      * Undefiniert
bra assline7                    * Rest der Zeile bearbeiten
macro3:
 lea einbuf(a5),a3
 suba.l a3,a0
 suba.l a3,a1
 lea ausbuf+insst(a5),a3
 adda.l a3,a0                   * Aktuelle Adresse
 adda.l a3,a1                   * Adresse des '.'
 move.b #' ',(a1)               * '.' berschreiben
 move.b #'{',(a3)               * Anfang der Zeile markieren
 movea.l a0,a3                  * Aktuelle Zeilenposition merken
 addq.l #4,a2                   * Pointer auf Anfangsadresse
 move.l akttxt(a5),-(a7)        * Alte Textadresse merken
 movea.l macroanf(a5),a0        * Zieladresse der Befehlsfolge
 move.l a0,-(a7)                * Merken falls Aufruf innerhalb eines Aufrufs
 move.l a0,akttxt(a5)           * Pointer setzen fr bersetzung
 move.l d3,-(a7)
 move.l d2,-(a7)                * Namen merken
 movea.l (a2)+,a1               * Anfangsadresse im Text holen
 move (a2)+,d7                  * Anzahl der Zeilen
 beq macrofi                    * Null, dann Ende
 subq #1,d7                     * -1 wegen Dbra
 move (a2),d4                   * Nummer des Aufrufs
 addq #1,(a2)                   * Einmal mehr aufgerufen
macro4:
 movea.l a0,a4                  * Adresse merken, falls spter gelscht wird
 move.l a1,(a0)+                * Adresse der Original-Zeile
macro5:
 move.b (a1)+,d0                * Zeichen holen
 cmp.b #'|',d0                  * Wenn nicht |,
 bne.s macro11                  * dann weiter
 move.b (a1)+,d1                * Nchstes Zeichen holen
 cmp.b #'|',d1                  * Ist es auch | ?
 bne.s macro5a                  * Nein, dann weiter
 move d4,d0                     * Zhler nach d0
 bsr print4d                    * Ausgabe
bra.s macro5                    * Schleife
macro5a:
 move.b d1,d2                   * Merken
 exg d0,d1                      * Tauschen, damit unten richtig herum abgelegt
 bsr dezcheck                   * Ist es eine Dezimalzahl ?
 bcs.s macro10                  * Nein, dann so lassen
 movea.l a3,a2                  * Adresse der aktuellen Zeilenposition merken
 tst.b d2                       * Platzhalternummer = 0
 beq.s macro8                   * Ja, dann weiter
macro6:
 move.b (a2)+,d3                * Zeichen holen
 cmp.b #',',d3                  * , ist Abgrenzung
 beq.s macro7                   * OK, weitersuchen
 cmp.b #$d,d3                   * Ende der Zeile ?
 beq.s macro10                  * Ja, dann nicht ersetzen
bra.s macro6                    * Schleife
macro7:
 subq.b #1,d2                   * Schleife bis richtiger
 bne.s macro6                   * Wert gefunden
macro8:
 cmp.b #' ',(a2)+               * Leerzeichen
 beq.s macro8                   * ignorieren
 cmp.b #$d,-(a2)                * Ende der Zeile ?
 beq.s macro10                  * Ja, dann weiter
 cmp.b #'|',(a2)                * Als erstes Zeichen |
 bne.s macro9                   * Nein, dann weiter
 movea.l a4,a0                  * Alte Zeilenanfangsadresse
macro8a:
 cmp.b #$d,(a1)+
 bne.s macro8a                  * Rest der Zeile ignorieren
bra.s macro12                   * Normal weiter
macro9:
 move.b (a2)+,d3                * Zeichen holen
 cmp.b #$d,d3                   * Ende der Zeile ?
 beq.s macro5                   * Ja, dann weiter bertragen
 cmp.b #',',d3                  * , ist Abgrenzung
 beq.s macro5                   * OK
 move.b d3,(a0)+                * Zeichen ablegen
bra.s macro9                    * Schleife
macro10:                        * Fehler
 move.b d1,(a0)+                * Zwei Zeichen wieder bertragen
macro11:
 move.b d0,(a0)+                * Zeichen ablegen
 cmp.b #$d,d0                   * $d ?
 bne.s macro5                   * Nein, dann nchstes Zeichen holen
 move.w a0,d0                   * Zieladresse
 btst.b #0,d0                   * Zeigt a0 auf ungerade Adresse ?
 beq.s macro12                  * Nein, dann weiter
 move.b #$a,-1(a0)              * $a als Lckenfller, da nicht beachtet
 move.b #$d,(a0)+               * $d als neue Endemarkierung
macro12:
dbra d7,macro4                  * Nchste Zeile
 clr.l (a0)+                    * Lckenfller fr Adresse (damit Ende erkannt)
 clr (a0)+                      * Endemarkierung
 move.l a0,macroanf(a5)         * Ziel fr neuen Macro (fr Aufruf im Aufruf)
 cmp #2,passflag(a5)            * Zweiter Durchgang ?
 beq.s macro14                  * Ja, dann weiter
 cmpa.l debugst(a5),a0          * berlagerung mit der Debug-Tabelle
 bmi.s macro13                  * Nein, dann weiter
 move.l a0,debugst(a5)          * Tabelle neu setzen
 move.l a0,debugak(a5)
macro13:
 addq.l #4,akttxt(a5)           * Adresse der alten Zeile berspringen
 bsr geteinbuf                  * Zeile holen
 bsr assline                    * bersetzen
 cmp #2,errflag(a5)             * Ende ?
 bne.s macro13                  * Nein, dann Schleife
 clr.b ausbuf(a5)               * Buffer ist leer
bra.s macrofi                   * Ende
macro14:
 movea.l akttxt(a5),a0          * Anfangsadresse der Zeile
 move.l (a0)+,anfzeile(a5)      * Anfangsadresse der Original-Zeile
 move.l a0,akttxt(a5)           * Neu einstellen
 tst errcnt(a5)                 * Fehler vorhanden
 bne.s macro15                  * OK, dann nicht verndern
 move.l anfzeile(a5),errzeile(a5) * Alte Zeile fr Fehler merken
macro15:
 bsr getquelle                  * Neue Zeile holen und letzte Zeile ausgeben
 bsr assline                    * Zeile bersetzen
 cmp.b #1,debug(a5)             * Debug an ?
 bne.s macro16                  * Nein, dann weiter
 move.l anfstand(a5),d0
 cmp.l pcstand(a5),d0           * Hat sich der PC-Stand verndert ?
 beq.s macro16                  * Nein, dann weiter
 movea.l debugak(a5),a0         * Adresse Debug
 move.l d0,(a0)+                * PC-Stand merken
 move.l anfzeile(a5),(a0)+      * Adresse der Zeile
 clr.l (a0)                     * Endekennung
 move.l a0,debugak(a5)          * Merken
macro16:
 and.b #1,debug(a5)             * Debug jetzt aktiv, wenn DEBUGAN erfolgte
 cmp #2,errflag(a5)             * Merker fr Ende
 bne.s macro14                  * Kein Ende, dann Schleife
 clr.b ausbuf(a5)               * Buffer ist leer
macrofi:
 clr errflag(a5)                * Endemerker wieder lschen
 bsr putausbuf                  * Letzte Zeile ausgeben
 lea ausbuf(a5),a0              * Ausgabebuffer
 move.l pcstand(a5),d0          * Adresse PC
 bsr print6x                    * Adresse ausgeben
 move.b #' ',(a0)               * Null am Ende berschreiben
 lea ausbuf+insst(a5),a0
 move.l (a7)+,(a0)+
 move.l (a7)+,(a0)+             * Name des Macros
 move #'}'*256+$0d,(a0)+        * Ende des Macros
 bsr putausbuf                  * Ausgeben
 clr.b ausbuf(a5)               * Ausbuf ist leer
 move.l (a7)+,macroanf(a5)      * Adressen zurck
 move.l (a7)+,akttxt(a5)
rts

ds 0
                                                                                                               R LF
 bsr prtco2                     * Ausgabe des Fehlertextes
bra crlfe                       * CR LF

errabbr:                        * Abbruch mit Fehlerausgabe
 move #2,passflag(a5)           * Ausgabe anschalten
 bsr prtco2                     * Text ausgeben
 bsr crlfe                      * Zeilenvorschub

abbruch:
 movea.l a6,a7                  * Stack zurck
 move #2,passflag(a5)           * Zweiter Durchgang, damit CO2 an
 move #2,errflag(a5)            * CO2 wirklich Ausgabe an
 le